<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SliderCategory extends Model 
{

    protected $table = 'slider_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function site()
    {
        return $this->hasOne('App\Model\Site');
    }

    public function sliders()
    {
        return $this->hasMany('App\Model\Slider', 'category_id', 'id')->orderBy('sorting', 'asc');
    }

}